C*****************************************************************************
c     FORTRAN code
c     File: STAR2.FOR
c     WRITTEN BY: Yuzhi CAI and adjusted by JDG
C
c     Program to find conditional pdf, cdf of SETAR model with given parameters
c     at a given forecast origin. Also finds median forecast and prediction
c     interval  from cdf and the mean, variance, and mean
c     absolute deviation from median.
c
c     If data have been transformed, either by log or Box-Cox square root, then
c     the pdf for the raw data is computed.
c
c     Throughout, a Gaussian noise distribution is assumed regionally.
c     References:
c     Cai, Y. (2003). 
c       Convergence theory of a numerical method for solving the Chapman-Kolmogorov 
c       equation. SIAM Journal on Numerical Analysis, 40(6), 2337-2351.
c       DOI: 10.1137/s0036142901390366.
c     Cai, Y. (2005). 
c       A forecasting procedure for nonlinear autoregressive time series models.
c       Journal of Forecasting, 24(5), 335-351.
c       DOI: 10.1002/for.959.
C
C     .. Parameters ..
C******************************************************************************      
C      INCLUDE 'UGLOBAL1.for'
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(-20:45),T(15),ABSC(2,40000),WGHT(2,40000),XMSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2),FF(8,10),
     * CABSC(1000),CWGHT(1000),FABS(2,40000),XMEANN(12),VARRR(20),
     * LEVL1(40000),LEVL(40000)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1
      INTEGER LEVL,TN
        COMMON K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1,LEVL,TN
        COMMON R2PI,X,T,ALAM,BLAM,SLAM,EPS,ABSC,WGHT,XMSE,FABS,R,Z,V,
     *  XMEANN,VARRR,XMA,XXX,XINC,XLASTL,XLASTV,FF,CABSC,CWGHT,XMI
c
      INTEGER         NIN, NOUT
      PARAMETER       (NIN=4,NOUT=8)
      DIMENSION PDF(1000),XAX(1000),aab(40)
C     CHARACTER*80TX,TY,TG
C     
      R2PI=SQRT(8.0*ATAN(1.0))
      EPS=1E-4
      OPEN(5,FILE='NEWPR.2RE')
      open(7,file='pdf.res')
      open(3,file='cdf.res')
C     YMI=0
C	UMI=0
C	UMA=1
C	VMI=0.1
C	VMA=0.9
C     TX='X(t)'
C     TY='Conditional pdf'
	CALL COFSS(AAB,IZK,SIGMAA)      
      WRITE(*,*) 'Z NA COFSS ',Z
C	CALL COEF(IZK,NZTHD,AAB,SIGMAA)
C      WRITE(*,*) 'Z NA COEF ',Z
C
c     
c     PRINT*,' INPUT 0 IF MODEL FITTED TO RAW DATA, 1 O.W.'
c     READ*,ITRANS
      itrans=0
      IF(ITRANS.EQ.1) THEN
	 PRINT*,' INPUT 1 FOR LOG, 2 FOR SQRT:'
	 READ*, ITRANS
      ENDIF
      IF(ITRANS.EQ.1)THEN
	PRINT*, 'BASE OF LOGS?'
	READ*,ALPHA
	BETA=LOG(ALPHA)
      ENDIF
c      PRINT*,'INPUT XMIN,XMAX FOR TRANSFORMED DATA:'
c      READ*,XMI,XMA
      xmi=0
      xma=1
c
c     PRINT*,'INPUT REQUIRED % LEVEL FOR PREDICTION LIMITS:'
c     READ*,CL
      cl=5
      BLEV=(1.0-CL/100.0)/2.0
      ULEV=1.0-BLEV
c     PRINT*,'LEFT AND RIGHT TAIL AREAS TO BE LEFT OFF ALL PDF PLOTS:'
c     READ*,PERL,PERR
      perl=0.2
      perr=0.2
c
      PERR=1-PERR
      PR100=100*PERR
      PL100=100*PERL
C
C	isup=0
C	ITYPE=0
C	KSYM=2
c
      CALL MANDV(ID,1,0)
c
C     WRITE(5,*)' MEAN      VARIANCE'
c     PRINT*,' MEAN      VARIANCE'
c     PRINT*,'TIME FOR MEANS/VARS UP TO ',ID,' = ',FINISH-START
C     WRITE(5,*)'TIME FOR MEANS/VARS UP TO ',ID,' = ',FINISH-START
C      
      DO 10 MFINAL=1,ID+3
        WRITE(7,*)'MFINAL=',MFINAL
        PRINT*,'MFINAL=',MFINAL
        LAST=0
        V=0
        XINIT=(XMI+XMA)/2
        XINC=.1*(XMA-XMI)
        XXX=XINIT
        IF(MFINAL.GT.ID)THEN
             PRINT*,'START NUMERICAL INTEGRATION'
             CALL RABWG
             XXX=XINIT
            CALL ROOT(0.5,AA) 
        ELSE
	    XLASTL=X(MFINAL+K)
	    XLASTV=XMSE(MFINAL)
	    AA=XLASTL
	    LAST=1
        ENDIF
c     
      XXX=AA
      CALL ROOT(ULEV,CHIH)
      XXX=AA
      CALL ROOT(BLEV,CLOW)
      XXX=CHIH
      CALL ROOT(PERR,XMA)
      XXX=CLOW
      CALL ROOT(PERL,XMI)
c     
      XAX(1)=XMI
      IX=0
      YMA=0
      PRINT*, 'XMA=',XMA
      PRINT*, 'XMI=',XMI
      H=(XMA-XMI)/50.0
c     
      DO 20 XX=XMI,XMA,H
         IX=IX+1
      IF(IX.GT.1000)write(5,*)'TOO MANY PDF VALUES FOR PLOTTING'
        XAX(IX)=XX
        XXX=XX
        CALL EVAL1(1,FX,FCUMX)
        PDF(IX)=FX
        YMA=MAX(YMA,FX)
        write(7,*)xx, fx
        write(3,*)xx,fcumx
20    CONTINUE
c     
      WRITE(5,*)
      WRITE(5,*)'# STEPS = ',MFINAL
      WRITE(5,*)
      WRITE(5,*)'MEDIAN BY NEWTON-RAPHSON METHOD IS ',AA
      WRITE(5,*)
      WRITE(5,*)CL,' % PRED LIMITS ARE ( ',CLOW,' , ',CHIH,' )'
      WRITE(5,*)'LOWER ',PL100,' % POINT IS ',XMI
      WRITE(5,*)'UPPER ',PR100,' % POINT IS ',XMA
      write(5,*)'varr(',mfinal,')=',sqrt(varrr(mfinal))
      write(5,*)'meann(',mfinal,')=',Xmeann(mfinal)
C     WRITE(5,21)
C     WRITE(TG,11)'CONDITIONAL PDF AT ',MFINAL,' STEPS'
C	CALL PTPLOT(XAX,PDF,UMI,UMA,VMI,VMA,XMI,XMA,YMI,YMA,
C    *ITYPE,KSYM,IX,TX,TY,TG,ISUP)
C	CALL J06WDF
      IF(ITRANS.EQ.1)THEN
	 WRITE(5,*)
	 WRITE(5,*)'BACKTRANSFORMING FROM LOGS TO BASE ',ALPHA
	 WRITE(5,*)'**************************************************'
	 WRITE(5,*)
	 XTMIN=EXP(BETA*XMI)
	 XTMAX=EXP(BETA*XMA)
	 AA=EXP(BETA*AA)
	 CLOW=EXP(BETA*CLOW)
	 CHIH=EXP(BETA*CHIH)
	 WRITE(5,*)
	 WRITE(5,*)'BACKTRANSFORMED MEDIAN IS ',AA
	 WRITE(5,*)'BACKTRANSFORMED PREDICTION LIMITS ARE ( ',CLOW,' ,
     1 ',CHIH,' )'
	 WRITE(5,*)'LOWER ',PL100,' % POINT IS ',XTMIN
	 WRITE(5,*)'UPPER ',PR100,' % POINT IS ',XTMAX
	 WRITE(5,*)
C        WRITE(5,21)
C	 WRITE(TG,41)'RAW DATA CONDITIONAL PDF AT ',MFINAL,' STEPS'
	 HT=(XTMAX-XTMIN)/50.0
	 IX=0
	 YMA=0
	 DO 40 XT=XTMIN,XTMAX,HT
	 IX=IX+1
	 XAX(IX)=XT
	 XXX=LOG(XAX(IX))/BETA
	 CALL EVAL1(0,FX,FCUMX)
	 PDF(IX)=FX/BETA/XAX(IX)
	 YMA=MAX(YMA,PDF(IX))
 40       CONTINUE
C
      ELSEIF(ITRANS.EQ.2)THEN
	 WRITE(5,*)
	 WRITE(5,*)'BACKTRANSFORMING FROM BOX-COX SQUARE ROOT'
	 WRITE(5,*)'**************************************************'
	 WRITE(5,*)
	 XTMIN=(XMI/2.0+1.0)**2-1.0
	 XTMAX=(XMA/2.0+1.0)**2-1.0
	 AA=(AA/2.0+1.0)**2-1.0
	 CLOW=(CLOW/2.0+1.0)**2-1.0
	 CHIH=(CHIH/2.0+1.0)**2-1.0
	 HT=(XTMAX-XTMIN)/50.0
	 IX=0
	 YMA=0
	 DO 30 XT=XTMIN,XTMAX,HT
	   IX=IX+1
	   XAX(IX)=XT
	   XXX=2*(SQRT(XT+1)-1)
	   CALL EVAL1(0,FX,FCUMX)
	   PDF(IX)=FX/(XXX/2+1)
	   YMA=MAX(YMA,PDF(IX))
30       CONTINUE
	 WRITE(5,*)
	 WRITE(5,*)'BACKTRANSFORMED MEDIAN IS ',AA
	 WRITE(5,*)
	 WRITE(5,*)'BACKTRANSFORMED PREDICTION LIMITS ARE ( ',CLOW,' ,
     1 ',CHIH,' )'
	 WRITE(5,*)'LOWER ',PL100,' % POINT IS ',XTMIN
	 WRITE(5,*)'UPPER ',PR100,' % POINT IS ',XTMAX
	 WRITE(5,*)
C         WRITE(5,21)
C	 WRITE(TG,41)'RAW DATA CONDITIONAL PDF AT ',MFINAL,' STEPS'
C	CALL PTPLOT(XAX,PDF,VMI,VMA,VMI,VMA,XTMIN,XTMAX,YMI,YMA,
C     *ITYPE,KSYM,IX,TX,TY,TG,ISUP)
C
      ENDIF
10    CONTINUE
C
C
      CLOSE(5)
      close(7)
      close(3)
11    FORMAT(A19,I2,A6)
41    FORMAT(A28,I2,A6)
      END
C
C     INCLUDE 'UUWWXXNEW.for'
C
C     Start of SUBROUTINE WWXX
C
      SUBROUTINE WWXX(A,B,LAM,S,NPTS,WW,XX,EE,NSIZE,NOUT)
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
       LOGICAL BOOL
C
C     Calculates the weights(WW) and the abscissae(XX) for the
C     NPTS-quadrature rule for the integral of
C              exp(-(t-lam)**2*s*s/2)*f(t)
C     with respect to t from a to b.The abscissae are stored in
C     XX(I,J),I=1,NPTS,J=1,I and the corresponding weights in
C     WW(I,J),I=1,NPTS,J=1,I.If for any reason the NPTS-rule cannot
C     be calculated the order of the highest rule which can be
C     found is stored in NOUT
C     All the calculations are done double length.
C     The vector E contains the error constant.
C
C     Parameters
C
      DIMENSION WW(0:NSIZE,0:NSIZE),XX(0:NSIZE,0:NSIZE),EE(0:NSIZE)
      REAL A,B,LAM,S,WW,XX,EE
      INTEGER NPTS,NOUT
C
C     Local variables
C
      DIMENSION II(0:20),V(0:20),AA(-1:20),BB(0:20),CC(0:20),
     *   ALPHA(0:20),BETA(0:20),GAMMA(0:20),
     *   WWW(0:20,0:20),XXX(0:20,0:20)
      DOUBLE PRECISION  II,V,AA,BB,CC,ALPHA,BETA,GAMMA,C,D,
     *   SUM,FACT,T1,T2,W,X,E,MAX,WWW,XXX
      INTEGER NMTS,I,J,K
C
C     Initialise variables
C
      C=DBLE((A-LAM)/S)
      D=DBLE((B-LAM)/S)
      NMTS=2*NPTS
C
C     Calculate the moments (II) and the generalised moments (V)
C
      CALL MOMENT(C,D,II,V,20,NMTS)
C
C     Check if the moments are small
C
      MAX=ABS(V(0))
      DO 10 I=1,NMTS
         IF(ABS(V(I)).GT.MAX) MAX=ABS(V(I))
   10 CONTINUE
      IF((MAX.LT.1D-6).OR.(ABS(V(0)).LT.1D-6)) THEN
         NOUT=0
         GOTO 51
      ENDIF
C     PRINT*
C      PRINT*,'MOMENTS'
C      DO 20 I=0,NMTS
C       PRINT*,II(I),V(I)
C   20 CONTINUE
C
C     Set up the fundamental matrix
C
      CALL FUNMAT(C,D,NMTS,AA,BB,CC,20)
C      PRINT*,'FUNDAMENTAL MATRIX'
C      DO 30 I=0,NMTS
C      PRINT*,AA(I),BB(I),CC(I)
C  30  CONTINUE
C
C     Set up the terminal matrix
C
      NOUT=NPTS
      CALL TERMAT(AA,BB,CC,II,V,NPTS,ALPHA,BETA,GAMMA,20,20,NOUT)
C     PRINT*
C      PRINT*,'TERMINAL MATRIX'
C      DO 40 I=0,NPTS
C       PRINT*,ALPHA(I),BETA(I),GAMMA(I)
C   40 CONTINUE
C
C     Now calculate the weights and abscissae for the n point rule
C
      XXX(1,0)=C
      XXX(1,1)=BETA(0)
      XXX(1,2)=D
      WWW(1,1)=V(0)
      DO 50 I=2,NOUT
      DO 60 J=1,I
      T1=XXX(I-1,J-1)
      T2=XXX(I-1,J)
      CALL NEWTON(T1,T2,ALPHA,BETA,GAMMA,I,20,W,X,BOOL)
      IF(.NOT.BOOL) THEN
       NOUT=I-1
       GOTO 51
      ENDIF
      WWW(I,J)=-W*V(0)
      XXX(I,J)=X
   60 CONTINUE
      XXX(I,0)=C
      XXX(I,I+1)=D
   50 CONTINUE
   51 CONTINUE
C     PRINT*
C      PRINT*,'  Weights and abscissae are as follows '
C      PRINT*
C      DO 80 I=1,NOUT
C         PRINT*,(WWW(I,J),XXX(I,J),J=1,I)
C   80 CONTINUE
C
C     Check the results
C
      FACT=1.0
      DO 90 I=1,NOUT
      FACT=2*I*(2*I-1)*FACT
      DO 100 J=0,2*I
       SUM=0.0
       DO 120 K=1,I
        IF(J.EQ.0) THEN
         SUM=SUM+WWW(I,K)
        ELSE
         SUM=SUM+WWW(I,K)*XXX(I,K)**J
        ENDIF
  120  CONTINUE
       E=II(J)-SUM
C      PRINT*,I,J,E,E/FACT
  100 CONTINUE
      EE(I)=REAL(E/FACT)
   90 CONTINUE
C 200 FORMAT(1X,6F10.4)
C
C     Finally transform the abscissae to (a,b)
C
      DO 300 I=1,NOUT
      DO 310 J=1,I
       XX(I,J)=REAL(XXX(I,J)*S+LAM)
       WW(I,J)=REAL(WWW(I,J))
  310 CONTINUE
  300 CONTINUE
C      PRINT*,(XX(NOUT,J),J=1,NOUT)
C      PRINT*,(WW(NOUT,J),J=1,NOUT)
C      PRINT*,'EE='
C      PRINT*,(EE(J),J=1,NOUT)
      END
C
C      INCLUDE 'RRABWG1.FOR'
C
C   THIS PROGRAM IS USED TO CALCULATE THE WEIGHTS AND ABSISSAE FOR THE 
C   NUMERICAL INTEGRATION FOR STAR MODEL.
c
      SUBROUTINE RABWG
C     INCLUDE 'UGLOBAL1.for'
c
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(-20:45),T(15),ABSC(2,40000),WGHT(2,40000),XMSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2),FF(8,10),
     * CABSC(1000),CWGHT(1000),FABS(2,40000),XMEANN(12),VARRR(20),
     * LEVL1(40000),LEVL(40000)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1
      INTEGER LEVL,TN
        COMMON K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1,LEVL,TN
        COMMON R2PI,X,T,ALAM,BLAM,SLAM,EPS,ABSC,WGHT,XMSE,FABS,R,Z,V,
     *  XMEANN,VARRR,XMA,XXX,XINC,XLASTL,XLASTV,FF,CABSC,CWGHT,XMI
C
c     REAL LAM,S,DM,PTOUT
      INTEGER L,M,JJ,KK,TJ
C
      M=MFINAL
      IF(M.EQ.ID+1) THEN
      L=1
      TT=1
      UU=1
      VV=0
      TN=0
      CALL ABWG(L,2,1)
      AT(2)=TT
      AT(1)=AT(2)
      DO 50 KK=2,AT(1)
      ABSC(1,KK)=ABSC(2,KK)
      WGHT(1,KK)=WGHT(2,KK)
      LEVL1(KK)=LEVL(KK)
50    CONTINUE
      ELSE
      TT=1
      L=1
      UU=1
      VV=0
      TN=0
      DO 40 JJ=2,AT(1)
      IF(LEVL1(JJ).GE.LEVL1(JJ+1)) THEN
      X(K+L)=ABSC(1,JJ)
      TJ=LEVL1(JJ)
      CALL STNOD1(WGHT(1,JJ),ABSC(1,JJ),2,JJ,TJ)
      CALL ABWG(L+1,2,JJ)
      L=LEVL1(JJ+1)-1
      ELSE
      TJ=LEVL1(JJ)
      L=TJ-1
      X(K+L)=ABSC(1,JJ)
      CALL STNOD1(WGHT(1,JJ),ABSC(1,JJ),2,JJ,TJ)
      L=LEVL1(JJ+1)-1
      GOTO 40
      END IF
40    CONTINUE
      AT(2)=TT
      AT(1)=AT(2)
      DO 70 KK=2,AT(1)
      ABSC(1,KK)=ABSC(2,KK)
      WGHT(1,KK)=WGHT(2,KK)
      LEVL1(KK)=LEVL(KK)
70    CONTINUE
      END IF
      END
C
C	INCLUDE 'COeFSS1.FOR'
C
	  SUBROUTINE COEF(IZK,NZTHD,AA,SIGMAA)
C	INCLUDE 'UGLOBAL1.FOR'
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(-20:45),T(15),ABSC(2,40000),WGHT(2,40000),XMSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2),FF(8,10),
     * CABSC(1000),CWGHT(1000),FABS(2,40000),XMEANN(12),VARRR(20),
     * LEVL1(40000),LEVL(40000)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1
      INTEGER LEVL,TN
        COMMON K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1,LEVL,TN
        COMMON R2PI,X,T,ALAM,BLAM,SLAM,EPS,ABSC,WGHT,XMSE,FABS,R,Z,V,
     *  XMEANN,VARRR,XMA,XXX,XINC,XLASTL,XLASTV,FF,CABSC,CWGHT,XMI
c
	 DIMENSION AA(40)
	T(1)=-1E7
	T(2)=1E7
	NZTHD=0
	K=IZK
	N=1
	BLAM(1)=AA(1)
	BLAM(2)=AA(K+2)
	DO 10 J=1,K
	ALAM(1,K-J+1)=AA(J+1)
	ALAM(2,K-J+1)=AA(J+K+2)
10      CONTINUE
	R=AA(2*K+3)
	Z=AA(2*K+4)
	SLAM(1)=SQRT(SIGMAA)
	RETURN
	END
C
C	INCLUDE 'DD1.FOR'
C
C     This program is used to calculates the variance of the conditional 
c      pdf as far as ID steps ahead for STAR MODEL.
      
      SUBROUTINE MANDV(M,L,FINAL)
C     INCLUDE 'UGLOBAL1.for'
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(-20:45),T(15),ABSC(2,40000),WGHT(2,40000),XMSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2),FF(8,10),
     * CABSC(1000),CWGHT(1000),FABS(2,40000),XMEANN(12),VARRR(20),
     * LEVL1(40000),LEVL(40000)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1
      INTEGER LEVL,TN
        COMMON K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1,LEVL,TN
        COMMON R2PI,X,T,ALAM,BLAM,SLAM,EPS,ABSC,WGHT,XMSE,FABS,R,Z,V,
     *  XMEANN,VARRR,XMA,XXX,XINC,XLASTL,XLASTV,FF,CABSC,CWGHT,XMI
C     
      INTEGER IFAIL,L,M,FINAL,L1,IL1,IL2,IR
      REAL PTOUT,A,LAM,COFER(25,25),S,CO,CO1
C    
      REAL erfc,DDXX
c
C     DOUBLE PRECISION DDXX
      WRITE(*,*) 'Z IN MANDV ',Z
      CALL LAMDA1(L,LAM,IR)
      COFER(1,1)=1.0
      X(L+K)=LAM
      XMSE(1)=SLAM(1)**2
      DO 999 L1=1,M-1
      CALL LAMDA1(L+L1,LAM,IR)
      X(L+L1+K)=LAM
      PTOUT=(X(K+L1+1-ID)-R)/Z
      DDXX=PTOUT
      IFAIL=0
c     A=S15ABF(DDXX,IFAIL)
      a=erfc(-ddxx/sqrt(2))/2   
c
      COFER(L1+1,L1+1)=1.0
      DO 10 IL1=1,L1
      CO=0
      CO1=0
      DO 20 IL2=IL1,L1
      CO=CO+COFER(L1-IL2+IL1,IL1)*ALAM(1,K-IL2+IL1)
      CO1=CO1+COFER(L1-IL2+IL1,IL1)*ALAM(2,K-IL2+IL1)
20    CONTINUE
      COFER(L1+1,IL1)=CO+CO1*A
10    CONTINUE 
      S=0.0
      IF(FINAL.EQ.1.AND.L1.NE.M-1) GOTO 999
      DO 30 IL1=1,L1+1
      S=S+COFER(L1+1,IL1)**2
30    CONTINUE
      XMSE(L1+1)=S*SLAM(1)**2
999   CONTINUE
      RETURN
      END
C
C     NAG PC GRAPHICS LIBRARY, RELEASE 1. NAG COPYRIGHT 1988
C	SUBROUTINE PTPLOT(X,Y,UMI,UMA,VMI,VMA,XMI,XMA,YMI,YMA,
C    1ITYPE,KSYM,NP,TX,TY,TG,ISUP)
C     .. Parameters ..
C     INTEGER         NIN, NOUT
C     PARAMETER       (NIN=4,NOUT=8)
C     INTEGER         MARGIN, IDIM
C     PARAMETER       (MARGIN=1,IDIM=1000)
C     .. Local Scalars ..
C     DOUBLE PRECISION UMA, UMI, VMA, VMI, XMA, XMI, YMA, YMI
C     INTEGER         I, IFAIL, ITYPE, KSYM, NP
C     .. Local Arrays ..
C     DOUBLE PRECISION X(IDIM), Y(IDIM)
C	CHARACTER*80 TX,TY,TG
C     .. External Subroutines ..
C     EXTERNAL        J06AAF, J06AHF, J06BAF, J06VAF, J06WBF,
C     *                J06WCF, J06XFF
C     .. Intrinsic Functions ..
C     INTRINSIC       DBLE, SIN
C     .. Executable Statements ..
C	IF(ISUP.EQ.0)THEN
C
C     Call NAG Graphical Interface to initialise
C     the NAG Graphics and indicate the data region.
C
C     CALL J06WBF(XMI,XMA,YMI,YMA,MARGIN)
C     CALL J06WCF(UMI,UMA,VMI,VMA)
C
C     Plot title and axis
C
C     CALL J06AHF(TG)
C     CALL J06AAF
C	ENDIF
C
C     Set high quality characters and markers
C
C     CALL J06XFF(2)
C     IF (NP.LE.0 .OR. NP.GT.IDIM) THEN
C	 WRITE (NOUT,FMT=99999)
C     ELSE
C
C        Plot the data
C
C	IFAIL=0
C	 CALL J06BAF(X,Y,NP,ITYPE,KSYM,IFAIL)
C     END IF
C
c99999 FORMAT (' NP is out of range')
c      END
C
C     Start of SUBROUTINE ROOT
C
      SUBROUTINE ROOT(C,ANS)
C     INCLUDE 'UGLOBAL1.for'
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(-20:45),T(15),ABSC(2,40000),WGHT(2,40000),XMSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2),FF(8,10),
     * CABSC(1000),CWGHT(1000),FABS(2,40000),XMEANN(12),VARRR(20),
     * LEVL1(40000),LEVL(40000)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1
      INTEGER LEVL,TN
        COMMON K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1,LEVL,TN
        COMMON R2PI,X,T,ALAM,BLAM,SLAM,EPS,ABSC,WGHT,XMSE,FABS,R,Z,V,
     *  XMEANN,VARRR,XMA,XXX,XINC,XLASTL,XLASTV,FF,CABSC,CWGHT,XMI
C
C     Finds the point ANS where the F(m,x/xt) takes the value C. Uses
C     Newtons' method.
C
C      IMPLICIT LOGICAL(A-Z)
C
C     Arguments
C
      REAL C,ANS
C
C     Global variables
C
C
C     Local variables
C
      REAL Y,FX,FDX,ANS1,ANS2
C
C     Newton's method
C
      CALL EVAL1(1,FDX,FX)
      LAST=1
99    Y=FX
      ANS1=XXX
      XXX=XXX+SIGN(1E20*XINC,C-FX)
      ANS2=MAX(ANS1,XXX)
      ANS1=MIN(ANS1,XXX)
      CALL EVAL1(1,FDX,FX)
      IF((FX-C)*(Y-C).LT.0.0)THEN
      Y=0.5*(ANS1+ANS2)
	ans=ans1
      ELSE
      GOTO 99
      ENDIF
C      WHILE(ABS(ANS-Y).GT.1E-4) DO
202     CONTINUE
	IF(ABS(ANS-Y).GT.1E-4)THEN
	ANS=Y
	XXX=ANS
	CALL EVAL1(1,FDX,FX)

	IF(FDX.GT.1E-10) THEN
	Y=ANS-(FX-C)/FDX
	ELSE
C        WHILE (ABS(ANS1-ANS2).GT.1E-4) DO
201     CONTINUE
	IF(ABS(ANS1-ANS2).GT.1E-4) THEN
	Y=0.5*(ANS1+ANS2)
	XXX=Y
	CALL EVAL1(1,FDX,FX)
	IF(FX.LT.C) THEN
	ANS1=Y
	ELSE
	ANS2=Y
	END IF
	GOTO 201
	ELSE
C        ENDWHILE
	Y=0.5*(ANS1+ANS2)
	GOTO 19
	END IF
	END IF
C
C        Y=ANS-(FX-C)/FDX
      IF(Y.LT.ANS1.OR.Y.GT.ANS2)THEN
203     CONTINUE
	IF(ABS(ANS1-ANS2).GT.1E-4) THEN
C      WHILE(ABS(ANS1-ANS2).GT.1E-4)DO
      Y=0.5*(ANS1+ANS2)
      XXX=Y
      CALL EVAL1(1,FDX,FX)
      IF(FX.LT.C)THEN
      ANS1=Y
      ELSE
      ANS2=Y
      ENDIF
C      ENDWHILE
	GOTO 203
	ELSE
	GOTO 19
	END IF
      ENDIF
      IF(FX.LT.C)THEN
      ANS1=Y
      ELSE
      ANS2=Y
      ENDIF
C      ENDWHILE
	GOTO 202
	END IF
C        ELSE
19    ANS=Y
C        END IF
      END
C
C      End of SUBROUTINE ROOT
C
C     Start of SUBROUTINE LAMBDA
C

      SUBROUTINE LAMBDA(L,SUM,S)
C      INCLUDE 'UGLOBAL1.for'
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(-20:45),T(15),ABSC(2,40000),WGHT(2,40000),XMSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2),FF(8,10),
     * CABSC(1000),CWGHT(1000),FABS(2,40000),XMEANN(12),VARRR(20),
     * LEVL1(40000),LEVL(40000)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1
      INTEGER LEVL,TN
        COMMON K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1,LEVL,TN
        COMMON R2PI,X,T,ALAM,BLAM,SLAM,EPS,ABSC,WGHT,XMSE,FABS,R,Z,V,
     *  XMEANN,VARRR,XMA,XXX,XINC,XLASTL,XLASTV,FF,CABSC,CWGHT,XMI
c
C      IMPLICIT LOGICAL(A-Z)
C
C     Arguments
C
      INTEGER L
C
C     Global variables
C
C     Local variables
C
      REAL SUM,S
      INTEGER I,J
      I=1
      DO 10 J=2,N
      IF(X(L-ID+K).LT.T(J)) GOTO 9
      I=J
10    CONTINUE
9     CONTINUE
C
C     I is the subspace number
C
      SUM=BLAM(I)
      DO 20 J=1,K
       SUM=SUM+ALAM(I,J)*X(L+J-1)
   20 CONTINUE
      S=SLAM(I)
      END
C
C     End of SUBROUTINE LAMBDA
C
C     Start of SUBROUTINE LAMDA1
C
CV      SUBROUTINE LAMDA1(L,SUM,I)
CV      IMPLICIT LOGICAL(A-Z)
C
C     Arguments
C
CV      INTEGER L,I
C
C     Global variables
C
CV      INCLUDE 'UGLOBAL.for'
C
C     Local variables
C
CV      REAL SUM
CV      INTEGER J
CV      I=1
CV      DO 10 J=2,N
CV      IF(X(L-ID+K).LT.T(J)) GOTO 9
CV      I=J
CV10    CONTINUE
CV9     CONTINUE
C
C     I is the subspace number
C
CV      SUM=BLAM(I)
CV      DO 20 J=1,K
CV       SUM=SUM+ALAM(I,J)*X(L+J-1)
CV   20 CONTINUE
CV      END
C
C
      SUBROUTINE LAMDA1(L,SUM,IR)
C
c      INCLUDE 'UGLOBAL1.for'
c
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(-20:45),T(15),ABSC(2,40000),WGHT(2,40000),XMSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2),FF(8,10),
     * CABSC(1000),CWGHT(1000),FABS(2,40000),XMEANN(12),VARRR(20),
     * LEVL1(40000),LEVL(40000)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1
      INTEGER LEVL,TN
        COMMON K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1,LEVL,TN
        COMMON R2PI,X,T,ALAM,BLAM,SLAM,EPS,ABSC,WGHT,XMSE,FABS,R,Z,V,
     *  XMEANN,VARRR,XMA,XXX,XINC,XLASTL,XLASTV,FF,CABSC,CWGHT,XMI
C
      INTEGER J,IFAIL,L,IR
      REAL A,B,SUM,PTOUT
      REAL erfc,DDXX
c     EXTERNAL S15ABF
c     DOUBLE PRECISION DDXX 
C     
      A=BLAM(1)
      B=BLAM(2)
      DO 20 J=1,K
      A=A+ALAM(1,J)*X(L+J-1)
      B=B+ALAM(2,J)*X(L+J-1)
20    CONTINUE
      write(*,*) 'Z =',Z
      PTOUT=(X(L+K-ID)-R)/Z
      DDXX=PTOUT
      IFAIL=0
c     SUM=S15ABF(DDXX,IFAIL)
      sum=erfc(-ddxx/sqrt(2))/2   
      SUM=A+B*SUM
      IR=1
      RETURN
      END
C
      SUBROUTINE ABWG(L,ML,JJ)
C     INCLUDE 'UGLOBAL1.for'
c
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(-20:45),T(15),ABSC(2,40000),WGHT(2,40000),XMSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2),FF(8,10),
     * CABSC(1000),CWGHT(1000),FABS(2,40000),XMEANN(12),VARRR(20),
     * LEVL1(40000),LEVL(40000)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1
      INTEGER LEVL,TN
        COMMON K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1,LEVL,TN
        COMMON R2PI,X,T,ALAM,BLAM,SLAM,EPS,ABSC,WGHT,XMSE,FABS,R,Z,V,
     *  XMEANN,VARRR,XMA,XXX,XINC,XLASTL,XLASTV,FF,CABSC,CWGHT,XMI
C
      INTEGER I,J,NMPTS,NOUT,KK,NDIM,IR,L,ML,JJ,L1,NE,JJJ
C 
      DIMENSION MESH(100),WW(0:10,0:10),XX(0:10,0:10),EE(0:10)
      REAL A,LAM,S,DM,T1,MESH,WW,XX,EE,AA,T2,T3,T4
      REAL PTOUT,AF(4000),AE(4000),PTOUT1,PTOUT2,AA1,AA2,T5,T6
      REAL T7,T8,T9,T10
      LOGICAL STD
      NPTS=3
      NDIM=10
      CALL LAMDA1(L,LAM,IR)
      S=SLAM(IR)
      DO 40 I=1,N+1
      MESH(I)=T(I)
40    CONTINUE
      NMPTS=N+1
      DO 50 I=0,6
      MESH(I+N+2)=LAM+(I-3)*S
50    CONTINUE
      NMPTS=NMPTS+7
      DO 60 I=NMPTS,1,-1
      DO 70 J=1,I-1
      IF (MESH(J)  .GT. MESH(J+1)) THEN
      A=MESH(J)
      MESH(J)=MESH(J+1)
      MESH(J+1)=A
      END IF
70    CONTINUE
60    CONTINUE
      DO 30 J=1,NMPTS-1
      IF(ABS(MESH(J)-MESH(J+1)).LT.1E-4) GOTO 31
      STD=.TRUE.
      DO 300 I=2,N
      IF(ABS(MESH(J)-T(I)).LT.1E-6) STD=.FALSE.
      IF(ABS(MESH(J+1)-T(I)).LT.1E-6) STD=.FALSE.
300   CONTINUE
      CALL WWXX(MESH(J),MESH(J+1),LAM,S,NPTS,WW,XX,EE,NDIM,NOUT)
      T1=0
      T5=0
      T6=0
      T7=0
      T9=0
      DO 190 KK=1,NOUT
      X(K+L)=XX(NOUT,KK)
      CALL STNOD1(WW(NOUT,KK),XX(NOUT,KK),ML,JJ,0)
      L1=L+1
      CALL MANDV(ID,L1,1)
      PTOUT=X(L1+K+ID-1)
      DM=XMSE(ID)
      PTOUT=(XXX-PTOUT)/SQRT(DM)
      PTOUT1=(XMI-PTOUT)/SQRT(DM)
      PTOUT2=(XMA-PTOUT)/SQRT(DM)
      AA=EXP(-0.5*PTOUT**2)/R2PI/SQRT(DM)
      AA1=EXP(-0.5*PTOUT1**2)/R2PI/SQRT(DM)
      AA2=EXP(-0.5*PTOUT2**2)/R2PI/SQRT(DM)
      T1=T1+AA*WW(NOUT,KK)                 
      T5=T5+AA1*WW(NOUT,KK)
      T6=T6+AA2*WW(NOUT,KK)
      T7=T7+PTOUT*WW(NOUT,KK)
      T9=T9+(DM+PTOUT**2)*WW(NOUT,KK)
190   CONTINUE
      AE(1)=MESH(J)
      AE(2)=(MESH(J+1)+MESH(J))*0.5
      AE(3)=MESH(J+1)
      NE=3 
370   T2=0     
      T3=0
      T4=0
      T8=0
      T10=0
      DO 10 JJJ=1,NE-1
      CALL WWXX(AE(JJJ),AE(JJJ+1),LAM,S,NPTS,WW,XX,EE,NDIM,NOUT)
      DO 220 KK=1,NOUT
      X(K+L)=XX(NOUT,KK)  
      CALL STNOD1(WW(NOUT,KK),XX(NOUT,KK),ML+1,JJ,0)
      L1=L+1
      CALL MANDV(ID,L1,1)
      PTOUT=X(L1+K+ID-1)
      DM=XMSE(ID)
       PTOUT=(XXX-PTOUT)/SQRT(DM)
      PTOUT1=(XMI-PTOUT)/SQRT(DM)
      PTOUT2=(XMA-PTOUT)/SQRT(DM)
      AA=EXP(-0.5*PTOUT**2)/R2PI/SQRT(DM)
      AA1=EXP(-0.5*PTOUT1**2)/R2PI/SQRT(DM)
      AA2=EXP(-0.5*PTOUT2**2)/R2PI/SQRT(DM)
      T2=T2+AA*WW(NOUT,KK)
      T3=T3+AA1*WW(NOUT,KK)
      T4=T4+AA2*WW(NOUT,KK)
      T8=T8+PTOUT*WW(NOUT,KK)
      T10=T10+(DM+PTOUT**2)*WW(NOUT,KK)
220   CONTINUE
10    CONTINUE
C      IF(((ABS(T1-T2).LT.ABS(T2)*EPS).OR.(ABS(T2).LT.EPS)).AND.
C     *   ((ABS(T5-T3).LT.ABS(T3)*EPS).OR.(ABS(T3).LT.EPS)).AND.
C     *   ((ABS(T6-T4).LT.ABS(T4)*EPS).OR.(ABS(T4).LT.EPS)).AND.
C     *   ((ABS(T7-T8).LT.ABS(T8)*EPS).OR.(ABS(T8).LT.EPS)).AND.
C     *   ((ABS(T9-T10).LT.ABS(T10)*EPS).OR.(ABS(T10).LT.EPS))) THEN

      IF(((ABS(T1-T2).LT.ABS(T2)*EPS).OR.(ABS(T2).LT.EPS)).AND.
     *   ((ABS(T5-T3).LT.ABS(T3)*EPS).OR.(ABS(T3).LT.EPS)).AND.
     *   ((ABS(T6-T4).LT.ABS(T4)*EPS).OR.(ABS(T4).LT.EPS))) THEN
      UU=1
      TN=TT
      VV=0
      GOTO 30
      ELSE
      DO 20 JJJ=1,NE
      AF(2*JJJ-1)=AE(JJJ)
20    CONTINUE
      DO 12 JJJ=1,NE-1
      AE(2*JJJ)=(AF(2*JJJ-1)+AF(2*JJJ+1))/2
      AE(2*JJJ-1)=AF(2*JJJ-1)
12    CONTINUE
      AE(2*NE-1)=AF(2*NE-1)
      NE=NE*2-1
      DO 330 KK=2,UU
      ABSC(2,KK+TN+VV)=CABSC(KK)
      WGHT(2,KK+TN+VV)=CWGHT(KK)
      LEVL(KK+TN+VV)=MFINAL-ID+1
330   CONTINUE
      TT=UU+TN+VV
      UU=1
      T1=T2
      T5=T3
      T6=T4
      GOTO 370
      END IF
C      END IF
C      END IF
      GOTO 30
31    PRINT*,'INTERVAL IS TOO SMALL'
30    CONTINUE
      END
C
      SUBROUTINE STNOD1(W,A,ML,JJ,TJ)
c      INCLUDE 'UGLOBAL1.for'
c
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(-20:45),T(15),ABSC(2,40000),WGHT(2,40000),XMSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2),FF(8,10),
     * CABSC(1000),CWGHT(1000),FABS(2,40000),XMEANN(12),VARRR(20),
     * LEVL1(40000),LEVL(40000)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1
      INTEGER LEVL,TN
        COMMON K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1,LEVL,TN
        COMMON R2PI,X,T,ALAM,BLAM,SLAM,EPS,ABSC,WGHT,XMSE,FABS,R,Z,V,
     *  XMEANN,VARRR,XMA,XXX,XINC,XLASTL,XLASTV,FF,CABSC,CWGHT,XMI
c
      REAL W,A
      INTEGER ML,JJ,TJ
C 
      IF(TJ.NE.0) THEN
      VV=VV+1
      TT=TT+1
      IF(TT.GT.50000) THEN
      PRINT*,'STACK HAS OVERFLOWED'
      STOP
      END IF
      WGHT(ML,TT)=W
      ABSC(ML,TT)=A
      LEVL(TT)=TJ
      GOTO 100
      END IF
      IF(ML.EQ.2) THEN
      TT=TT+1
      IF(TT.GT.50000) THEN
      PRINT*,'STACK HAS OVERFLOWED'
      STOP
      END IF
      LEVL(TT)=MFINAL-ID+1
      WGHT(ML,TT)=W
      ABSC(ML,TT)=A
      ELSE
      UU=UU+1
      CWGHT(UU)=W
      CABSC(UU)=A
      END IF
100   RETURN
      END
c    
      SUBROUTINE EVAL1(ICUM,A,B)
c
c     INCLUDE 'UGLOBAL1.for'
c
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(-20:45),T(15),ABSC(2,40000),WGHT(2,40000),XMSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2),FF(8,10),
     * CABSC(1000),CWGHT(1000),FABS(2,40000),XMEANN(12),VARRR(20),
     * LEVL1(40000),LEVL(40000)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1
      INTEGER LEVL,TN
        COMMON K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1,LEVL,TN
        COMMON R2PI,X,T,ALAM,BLAM,SLAM,EPS,ABSC,WGHT,XMSE,FABS,R,Z,V,
     *  XMEANN,VARRR,XMA,XXX,XINC,XLASTL,XLASTV,FF,CABSC,CWGHT,XMI
C
      REAL A,SUM1,SUM2,DM,PTOUT,B,W(20)
      INTEGER ICUM,I,L,IK
C     DOUBLE PRECISION DDXX
      REAL erfc,DDXX
c     
      IF (MFINAL.LE.ID) THEN
      PTOUT=XLASTL
      DM=XLASTV
      XMEANN(MFINAL)=PTOUT
      VARRR(MFINAL)=DM
      WRITE(*,*) 'DM IN EVAL1 = ',DM
      PTOUT=(XXX-PTOUT)/SQRT(DM)
      IF(ICUM.GT.0) THEN
      DDXX=PTOUT
C     IFAIL=0
c     B=S15ABF(DDXX,IFAIL)
      b=erfc(-ddxx/sqrt(2))/2   
c
      END IF
      A=EXP(-0.5*PTOUT**2)/R2PI/SQRT(DM)
      ELSE
      DO 20 I=1,K
      W(I)=1.0
20    CONTINUE
      L=1
      LEVL1(AT(1)+1)=2
      SUM1=0
      SUM2=0
      IF (LAST.EQ.0) THEN
      XMEANN(MFINAL)=0
      VARRR(MFINAL)=0
      END IF
      DO 30 I=2,AT(1)
      IK=I-1
      L=1+L
      X(L+K-1)=ABSC(1,I)
      W(L+K-1)=WGHT(1,I)*W(L+K-2)
      IF(LEVL1(I).GE.LEVL1(I+1)) THEN
      IF(LAST.EQ.0) THEN
      V=V+W(L+K-1)
      CALL MANDV(ID,L,1)
      PTOUT=X(L+K+ID-1)
      DM=XMSE(ID)
      FABS(1,IK)=PTOUT
      FABS(2,IK)=DM
      XMEANN(MFINAL)=XMEANN(MFINAL)+PTOUT*W(L+K-1)
      VARRR(MFINAL)=VARRR(MFINAL)+(DM+PTOUT**2)*W(L+K-1)
      ELSE
      PTOUT=FABS(1,IK)
      DM=FABS(2,IK)
      END IF
      PTOUT=(XXX-PTOUT)/SQRT(DM)
      A=EXP(-0.5*PTOUT**2)/R2PI/SQRT(DM)
      SUM1=SUM1+W(L+K-1)*A
      IF(ICUM.GT.0) THEN
      DDXX=PTOUT
C     IFAIL=0
c     PTOUT=S15ABF(DDXX,IFAIL)
      ptout=erfc(-ddxx/sqrt(2))/2   
      SUM2=SUM2+W(L+K-1)*PTOUT
      END IF
      L=LEVL1(I+1)-1
      END IF
30    CONTINUE
      A=SUM1/V
      B=SUM2/V
      IF(LAST.EQ.0) THEN
      XMEANN(MFINAL)=XMEANN(MFINAL)/V
      VARRR(MFINAL)=VARRR(MFINAL)/V
      VARRR(MFINAL)=VARRR(MFINAL)-XMEANN(MFINAL)**2
      END IF
      END IF
      END
C
C     Start of FUNMAT
C
      SUBROUTINE FUNMAT(C,D,NPTS,AA,BB,CC,NDIM)
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)

C
C     Calculates the coefficients in the fundamental matrix
C
C      IMPLICIT LOGICAL (A-Z)
C
C     Parameters
C
      INTEGER NPTS,NDIM
      DIMENSION AA(-1:NDIM),BB(0:NDIM),CC(0:NDIM)
      DOUBLE PRECISION AA,BB,CC,C,D
C
C     Local variables
C
      DOUBLE PRECISION E,F,CBAR,DBAR,CONST
      INTEGER I
C
C     Shifted Legendre
C
      CONST=9.0
      IF(C.GT.0.0) THEN
       CBAR=C
       E=SQRT(C*C+CONST)
       DBAR=D
       IF(E.LT.DBAR) DBAR=E
      ELSEIF(D.LT.0.0) THEN
       DBAR=D
       E=-SQRT(D*D+CONST)
       CBAR=C
       IF(E.GT.CBAR) CBAR=E
      ELSE
       E=SQRT(CONST)
       CBAR=C
       IF(-E.GT.CBAR) CBAR=-E
       DBAR=D
       IF(E.LT.DBAR) DBAR=E
      ENDIF
      E=(DBAR-CBAR)/2.0
      F=(CBAR+DBAR)/2.0
      AA(-1)=0.0
      DO 20 I=0,NPTS
       AA(I)=(I+1.0)*E/(2.0*I+1.0)
       BB(I)=F
       CC(I)=I*E/(2.0*I+1.0)
   20 CONTINUE
C
C     Hermite fundamental matrix
C
C     E=SQRT(2.0)
C     AA(-1)=E/2.0
C     DO 30 I=0,NPTS
C       AA(I)=E/2.0
C       BB(I)=0.0
C       CC(I)=E*I
C  30 CONTINUE
C
C     Laguerre
C
C     AA(-1)=0.0
C     DO 50 I=0,NPTS
C      AA(I)=-1.0/C
C      BB(I)=(1.0+2.0*I+C*C)/C
C      CC(I)=-I*I/C
C  50 CONTINUE
C
C     Binomial
C
C     DO 40 I=0,NPTS
C      AA(I)=1.0
C      BB(I)=C
C      CC(I)=0.0
C  40 CONTINUE
      END
C
C     End of FUNMAT
C
      SUBROUTINE MOMENT(C,D,II,V,MDIM,NMTS)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     Program to calculate the moments II(i)=u**iexp(-u*u/2)/r2pi
C     between a and b for i=0,...,nmts and the generalised moments
C     V(i)=P(i)*exp(-u*u/2)/rtpi
C
C      IMPLICIT LOGICAL (A-Z)
C
C     Parameters
C
      INTEGER mdim,NMTS
      DIMENSION II(0:MDIM),V(0:MDIM)
      DOUBLE PRECISION C,D,II,V
C
C     Local variables
C
      DIMENSION ZZ(0:20),COEF(0:20,0:20),III(0:20)
      DOUBLE PRECISION ZZ,COEF,E,F,SUM,R2PI,III
      REAL W
      real CC,DD,WW
      INTEGER I,J
C     Function references
C
      real erfc
C
C     THE CUMULATIVE NORMAL DISTRIBUTION IS EQUAL
C     TO P(X) = ERFC(-X/SQRT(2))/2
c
      DD=D
      ww=erfc(-dd/sqrt(2))/2   
      CC=C
      ww=ww-erfc(-cc/sqrt(2))/2   
C
C     WW = P(D) - P(C)
c
c     W=WW
      R2PI=SQRT(8.0*ATAN(1.0))
      ZZ(0)=WW
      F=EXP(-DD*DD/2.0)
      E=EXP(-CC*CC/2.0)
      DO 20 I=1,NMTS
        ZZ(I)=(F-E)/R2PI
        E=CC*E
        F=DD*F
   20 CONTINUE
C
C     We have now calculated the integrated terms in the definition
C     of the II(N).Now calculate the II(N) from the recurrence
C     relation II(N)=(N-1)*II(N-2)-U**(N-1)EXP(-U*U/2)/R2PI where
C     the last term is evaluated at c,d
C
      III(0)=ZZ(0)
      III(1)=-ZZ(1)
      DO 50 J=2,NMTS
        III(J)=(J-1)*III(J-2)-ZZ(J)
   50 CONTINUE
C
C     The moments II(N) have been calculated,now find the generalised
C     moments.First calculate the coefficients of the shifted Legendre
C     polynomials.If c and/or d is very large replace them by CBAR,DBAR
C     i.e work with the moments based on a finite interval.
C
CV      CONST=9.0
CV      IF(CC.GT.0.0) THEN
CV       CBAR=CC
CV       E=SQRT(CC*CC+CONST)
CV       DBAR=DD
CV       IF(E.LT.DBAR) DBAR=E
CV      ELSEIF(DD.LT.0.0) THEN
CV       DBAR=DD
CV       E=-SQRT(DD*DD+CONST)
CV       CBAR=CC
CV       IF(E.GT.CBAR) CBAR=E
CV      ELSE
CV       E=SQRT(CONST)
CV       CBAR=CC
CV       IF(-E.GT.CBAR) CBAR=-E
CV       DBAR=DD
CV       IF(E.LT.DBAR) DBAR=E
CV      ENDIF
CV      E=2.0/(DBAR-CBAR)
CV       F=-(CBAR+DBAR)/(DBAR-CBAR)
       E=2.0/(DD-CC)
       F=-(CC+DD)/(DD-CC)
C      PRINT*,'E,F'
C      PRINT*,E,F
C
C     Calculate the coeffs for shifted Legendre
C
      COEF(0,0)=1.0
      COEF(0,1)=0.0
      COEF(0,2)=0.0
      COEF(1,0)=F
      COEF(1,1)=E
      COEF(1,2)=0.0
      COEF(1,3)=0.0
C
C     GAUSS-LEGENDRE EQUATION (4.5.10) ON P. 144
C     SHIFTED  (AND DIVIDED)
C
      DO 60 I=2,NMTS
      DO 70 J=1,I
        COEF(I,J)=COEF(I-1,J)*F*(2.0*I-1.0)/I-(I-1)*COEF(I-2,J)/I
        COEF(I,J)=COEF(I,J)+E*(2.0*I-1.0)/I*COEF(I-1,J-1)
   70 CONTINUE
      COEF(I,0)=COEF(I-1,0)*F*(2.0*I-1.0)/I-(I-1)*COEF(I-2,0)/I
      COEF(I,I+1)=0.0
      COEF(I,I+2)=0.0
   60 CONTINUE
C
C     Calculate coeffs of Hermite
C
C     E=SQRT(2.0)
C     COEF(0,0)=1.0
C     COEF(0,1)=0.0
C     COEF(0,2)=0.0
C     COEF(1,0)=0.0
C     COEF(1,1)=E
C     COEF(1,2)=0.0
C     COEF(1,3)=0.0
C     DO 61 I=2,NMTS
C     DO 71 J=1,I
C       COEF(I,J)=E*COEF(I-1,J-1)-2.0*(I-1)*COEF(I-2,J)
C  71 CONTINUE
C     COEF(I,0)=-2.0*(I-1)*COEF(I-2,0)
C     COEF(I,I+1)=0.0
C     COEF(I,I+2)=0.0
C  61 CONTINUE
C
C     Calculate the coeffs for the scaled Laguerre
C
C     E=CC
C     COEF(0,0)=1.0
C     COEF(0,1)=0.0
C     COEF(0,2)=0.0
C     COEF(1,0)=1.0+E*E
C     COEF(1,1)=-E
C     COEF(1,2)=0.0
C     COEF(1,3)=0.0
C     DO 61 I=2,NMTS
C     DO 71 J=1,I
C       COEF(I,J)=-E*COEF(I-1,J-1)+(2*I-1+E*E)*COEF(I-1,J)
C    *              -(I-1)**2*COEF(I-2,J)
C  71 CONTINUE
C     COEF(I,0)=(2.0*I-1.0+E*E)*COEF(I-1,0)-(I-1)**2*COEF(I-2,0)
C     COEF(I,I+1)=0.0
C     COEF(I,I+2)=0.0
C  61 CONTINUE
C
C     Calculate binomial coeffs
C
C     COEF(0,0)=1.0
C     COEF(0,1)=0.0
C     COEF(1,0)=-CC
C     COEF(1,1)=1.0
C     COEF(1,2)=0.0
C     DO 65 I=2,NMTS
C     DO 66 J=1,I
C      COEF(I,J)=COEF(I-1,J-1)-CC*COEF(I-1,J)
C  66 CONTINUE
C     COEF(I,0)=-CC*COEF(I-1,0)
C     COEF(I,I+1)=0.0
C  65 CONTINUE
C     DO 62 I=0,NMTS
C      PRINT 63,(COEF(I,J),J=0,I)
C  62 CONTINUE
C  63  FORMAT(1X,10F6.2)
C
C     ...and finally the generalised moments
C
      DO 80 I=0,NMTS
        SUM=0.0
        DO 90 J=0,I
          SUM=SUM+COEF(I,J)*III(J)
   90   CONTINUE
        V(I)=SUM
        II(I)=III(I)
   80 CONTINUE
      END
C
C     End of MOMENT
C
C     Start of TERMAT
C
      SUBROUTINE TERMAT(AA,BB,CC,II,V,NPTS,ALPHA,BETA,GAMMA,NDIM,MDIM,
     *                   NOUT)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     Sets up the terminal matrix
C     THIS ROUTINE IS IDENTICAL TO THE PROCEDURE "ORTHOG" IN
C     "NUMERICAL RECIPES" P. 153
C     INPUTS ARE THE GENERALIZED (OR MODIFIED) MOMENTS V(J); 
C     SEE (4.5.3) ON P.152  OF "NUM.RECIPES" WITH
C     W(X) THE GAUSS-LEGENDRE WEIGHTS; SEE P. 141
C
C      IMPLICIT LOGICAL (A-Z)
C
C     Parameters
C
      INTEGER NPTS,NDIM,MDIM,NOUT
      DIMENSION AA(-1:NDIM),BB(0:NDIM),CC(0:NDIM),II(0:MDIM),
     * V(0:MDIM),ALPHA(0:NDIM),BETA(0:NDIM),GAMMA(0:NDIM)
      DOUBLE PRECISION AA,BB,CC,II,V,ALPHA,BETA,GAMMA
C
C     Local variables
C
      DIMENSION SS(-1:20,0:20)
      DOUBLE PRECISION SS,R,S,T
      INTEGER I,J,NMTS
      NMTS=2*NPTS
C
C     Initialize the first 2 rows of SS
C     SEE ALSO P. 152 EQUATION (4.5.33) IN "NUM.RECIPES"
C
      GAMMA(0)=0.0
      DO 20 J=0,NMTS
       SS(-1,J)=0.0
   20 CONTINUE
      DO 30 J=0,NMTS
        SS(0,J)=V(J)/V(0)
   30 CONTINUE
C
C     Now use the recurrence relation for the other rows
C     SEE ALSO P. 152 EQUATION (4.5.34) IN "NUM.RECIPES"
C
      DO 40 I=0,NPTS-1
       T=AA(I-1)
       S=AA(I)*SS(I,I+1)+BB(I)-AA(I-1)*SS(I-1,I)
       R=(BB(I+1)-S)*SS(I,I+1)+AA(I+1)*SS(I,I+2)-AA(I-1)*SS(I-1,I+1)
     *       +CC(I+1)
       BETA(I)=S
       IF(I.EQ.NPTS-1) GOTO 40
       DO 50 J=0,I
        SS(I+1,J)=0.0
   50  CONTINUE
        SS(I+1,I+1)=1.0
       DO 70 J=I+2,2*NPTS-1-I
        SS(I+1,J)=1.0/R*((BB(J)-S)*SS(I,J)+AA(J)*SS(I,J+1)+
     *                CC(J)*SS(I,J-1)-T*SS(I-1,J))
   70  CONTINUE
       IF(AA(I)*R.LT.0.0) THEN
C       PRINT*,'  ERROR IN TERMINAL MATRIX '
C       PRINT*,'  VALUE OF I IS',I,'CAN ONLY COMPUTE RULES UP TO'
C       PRINT*,'     LEVEL ',I+1
        NOUT=I+1
        RETURN
       ENDIF
       ALPHA(I)=SQRT(AA(I)*R)
       GAMMA(I+1)=ALPHA(I)
   40 CONTINUE
      END
C
C     End of TERMAT
c
C
      FUNCTION erfc(x)
      REAL erfc,x
CU    USES gammp,gammq
      REAL gammp,gammq
      if(x.lt.0.)then
        erfc=1.+gammp(.5,x**2)
      else
        erfc=gammq(.5,x**2)
      endif
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
c
      FUNCTION gammp(a,x)
      REAL a,gammp,x
CU    USES gcf,gser
      REAL gammcf,gamser,gln
      if(x.lt.0..or.a.le.0.)pause 'bad arguments in gammp'
      if(x.lt.a+1.)then
        call gser(gamser,a,x,gln)
        gammp=gamser
      else
        call gcf(gammcf,a,x,gln)
        gammp=1.-gammcf
      endif
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
      SUBROUTINE gser(gamser,a,x,gln)
      INTEGER ITMAX
      REAL a,gamser,gln,x,EPS
      PARAMETER (ITMAX=100,EPS=3.e-7)
CU    USES gammln
      INTEGER n
      REAL ap,del,sum,gammln
      gln=gammln(a)
      if(x.le.0.)then
        if(x.lt.0.)pause 'x < 0 in gser'
        gamser=0.
        return
      endif
      ap=a
      sum=1./a
      del=sum
      do 11 n=1,ITMAX
        ap=ap+1.
        del=del*x/ap
        sum=sum+del
        if(abs(del).lt.abs(sum)*EPS)goto 1
11    continue
      pause 'a too large, ITMAX too small in gser'
1     gamser=sum*exp(-x+a*log(x)-gln)
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
      FUNCTION gammq(a,x)
      REAL a,gammq,x
CU    USES gcf,gser
      REAL gammcf,gamser,gln
      if(x.lt.0..or.a.le.0.)pause 'bad arguments in gammq'
      if(x.lt.a+1.)then
        call gser(gamser,a,x,gln)
        gammq=1.-gamser
      else
        call gcf(gammcf,a,x,gln)
        gammq=gammcf
      endif
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
      SUBROUTINE gcf(gammcf,a,x,gln)
      INTEGER ITMAX
      REAL a,gammcf,gln,x,EPS,FPMIN
      PARAMETER (ITMAX=100,EPS=3.e-7,FPMIN=1.e-30)
CU    USES gammln
      INTEGER i
      REAL an,b,c,d,del,h,gammln
      gln=gammln(a)
      b=x+1.-a
      c=1./FPMIN
      d=1./b
      h=d
      do 11 i=1,ITMAX
        an=-i*(i-a)
        b=b+2.
        d=an*d+b
        if(abs(d).lt.FPMIN)d=FPMIN
        c=b+an/c
        if(abs(c).lt.FPMIN)c=FPMIN
        d=1./d
        del=d*c
        h=h*del
        if(abs(del-1.).lt.EPS)goto 1
11    continue
      pause 'a too large, ITMAX too small in gcf'
1     gammcf=exp(-x+a*log(x)-gln)*h
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
      FUNCTION gammln(xx)
      REAL gammln,xx
      INTEGER j
      DOUBLE PRECISION ser,stp,tmp,x,y,cof(6)
      SAVE cof,stp
      DATA cof,stp/76.18009172947146d0,-86.50532032941677d0,
     *24.01409824083091d0,-1.231739572450155d0,.1208650973866179d-2,
     *-.5395239384953d-5,2.5066282746310005d0/
      x=xx
      y=x
      tmp=x+5.5d0
      tmp=(x+0.5d0)*log(tmp)-tmp
      ser=1.000000000190015d0
      do 11 j=1,6
        y=y+1.d0
        ser=ser+cof(j)/y
11    continue
      gammln=tmp+log(stp*ser/x)
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
c
C
C     Start of NEWTON
C
      SUBROUTINE NEWTON(AA,BB,ALPHA,BETA,GAMMA,NPTS,NDIM,W,X,BOOL)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      LOGICAL BOOL
C
C     Calculates the root(X) of the orthogonal polynomial which lies
C     in (a,b) and the associated weight(W)
C     SEE ALSO "NUMERICAL RECIPES" P. 142 F.
C
C     IMPLICIT LOGICAL (A-Z)
C
C     Parameters
C
      INTEGER NPTS,NDIM
      DIMENSION ALPHA(0:NDIM),BETA(0:NDIM),GAMMA(0:NDIM)
      DOUBLE PRECISION AA,BB,ALPHA,BETA,GAMMA,W,X
C
C     Local variables
C
      DOUBLE PRECISION A,B,FA,FB,FX,FDX,R,EPS,Y,SIGN
      INTEGER J
      EPS=1D-12
      BOOL=.TRUE.
C
C     First test if the interval is semi-infinite.If it is try to
C     find a finite interval (a,b) which contains a root.
C
      A=AA
      B=BB
      IF((A.LT.-1E3).OR.(B.GT.1E3)) THEN
        IF(A.LT.-1E3) THEN
         X=B
         SIGN=-1.1
        ELSE
         X=A
         SIGN=1.1
        ENDIF
        CALL FANDD(X,FA,FDX,R,NPTS,ALPHA,BETA,NDIM)
        DO 20 J=1,5
         X=X+SIGN
         CALL FANDD(X,FB,FDX,R,NPTS,ALPHA,BETA,NDIM)
         IF(FA*FB.LT.0.0) GOTO 300
   20   CONTINUE
C        PRINT*,'NO ROOT IN INTERVAL '
        BOOL=.FALSE.
        RETURN
  300   IF(SIGN.GT.0.0) THEN
         A=X-SIGN
         B=X
        ELSE
         A=X
         B=X-SIGN
        ENDIF
C       PRINT*,'SEMI INF REDUCED TO ',A,B
      ENDIF
C
C     Test for sign change in (a,b)
C
      CALL FANDD(A,FA,FDX,R,NPTS,ALPHA,BETA,NDIM)
      CALL FANDD(B,FB,FDX,R,NPTS,ALPHA,BETA,NDIM)
      IF(FA*FB.GT.0.0) THEN
C        PRINT*,'   NO ROOT IN ',A,B
C        PRINT*,' CANNOT COMPUTE',NPTS,' RULE '
        BOOL=.FALSE.
        RETURN
      ELSE
C
C     Compute new iterate
C
  200   X=(A+B)/2.0
  100   CALL FANDD(X,FX,FDX,R,NPTS,ALPHA,BETA,NDIM)
        Y=X-FX/FDX
C       PRINT*,X,Y
        IF(ABS(X-Y).LT.EPS) THEN
         W=R/FDX
         X=Y
        ELSEIF(A.LT.Y.AND.Y.LT.B) THEN
           X=Y
           GOTO 100
        ELSE
C
C     Bisection
C
          IF(FA*FX.LT.0.0) THEN
            B=X
          ELSE
            A=X
          ENDIF
          GOTO 200
        ENDIF
      ENDIF
      END
C
C     End of NEWTON
C
C     Start of subroutine FANDD
C
      SUBROUTINE FANDD(X,FX,FDX,R,NPTS,ALPHA,BETA,NDIM)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C     Subroutine to calculate the orthogonal function,its derivative
C     and the value c(1)
C
C      IMPLICIT LOGICAL(A-Z)
C
C     Parameters
C
      INTEGER NPTS,NDIM
      DIMENSION ALPHA(0:NDIM),BETA(0:NDIM)
      DOUBLE PRECISION ALPHA,BETA,X,FX,FDX,R
C
C     Local variables
C
      DIMENSION C(0:100),D(0:100)
      DOUBLE PRECISION C,D
      INTEGER J
      C(NPTS+1)=0.0
      D(NPTS+1)=0.0
      C(NPTS)=1.0
      D(NPTS)=0.0
C      PRINT*,(ALPHA(J),BETA(J),J=NPTS-1,0,-1)
      J=NPTS-1
      C(J)=BETA(J)-X
      D(J)=-1.0
      DO 20 J=NPTS-2,0,-1
       C(J)=(BETA(J)-X)*C(J+1)-ALPHA(J)**2*C(J+2)
       D(J)=(BETA(J)-X)*D(J+1)-ALPHA(J)**2*D(J+2)-C(J+1)
   20 CONTINUE
      FX=C(0)
      FDX=D(0)
      R=C(1)
      END
C
C     End of FANDD

        SUBROUTINE COFSS(AA,IZK,SIGMAA)
c
c        INCLUDE 'UGLOBAL1.FOR'
c
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION X(-20:45),T(15),ABSC(2,40000),WGHT(2,40000),XMSE(25)
      DIMENSION ALAM(16,20),BLAM(16),SLAM(16),AT(2),FF(8,10),
     * CABSC(1000),CWGHT(1000),FABS(2,40000),XMEANN(12),VARRR(20),
     * LEVL1(40000),LEVL(40000)
      INTEGER K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1
      INTEGER LEVL,TN
        COMMON K,N,MFINAL,ID,TT,LAST,AT,NPTS,UU,VV,LEVL1,LEVL,TN
        COMMON R2PI,X,T,ALAM,BLAM,SLAM,EPS,ABSC,WGHT,XMSE,FABS,R,Z,V,
     *  XMEANN,VARRR,XMA,XXX,XINC,XLASTL,XLASTV,FF,CABSC,CWGHT,XMI
C
c
        REAL AA(40),A(0:40),B(0:40)
c        
        ID=1
        SIGMAA=1.572288521331E-02
        IZK=3
        A(0)=0.000000000000E+0000
        A(1)=0.286118446625
        A(2)=0.000000000000E+0000
        A(3)=0.756040224853
        B(0)=0.000000000000E+0000
        B(1)=0.756040224853
        B(2)=0.345890977224
        B(3)=-1.14761428328
        R=1.05448145744
        Z=0.483764124691
        X(1)=LOG10(16.)
        X(2)=LOG10(19.)
        X(3)=LOG10(26.)
c
        IF(IZK.GE.ID) THEN
        DO 219 I=0,IZK
        AA(I+1)=A(I)
        AA(IZK+I+2)=B(I)
219     CONTINUE
        AA(2*IZK+3)=R
        AA(2*IZK+4)=Z
        ELSE
        AA(2*ID+3)=R
        AA(2*ID+4)=Z
        DO 319 I=IZK+1,ID
        AA(I+1)=0
        AA(ID+I+2)=0
319     CONTINUE
        DO 3213 I=0,IZK
        AA(I+1)=A(I)
        AA(ID+I+2)=B(I)
3213    CONTINUE
        IZK=ID
        END IF
C       
        RETURN
        END 
